/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigTreeNode;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;
import javax.swing.ImageIcon;

public class VWConfigVWServiceNode
extends VWConfigBaseNode
implements IVWConfigTreeNode {
    public static final int REGIONS_LOGON = 1;
    public static final int REGIONS_UNLOGON = 2;
    public static final int REGIONS_ALL = 3;
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("wf_service_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("wf_service_16.gif");
    protected int m_numRegionActive = 0;
    protected VWSystemAdministration m_sysAdmin = null;

    public VWConfigVWServiceNode(String sysName) {
        super(sysName, 18, VWConfigActionCommand.ACMD_SYSTEM);
        this.m_serviceName = sysName;
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
    }

    public void registRegion(boolean b) {
        this.m_numRegionActive = b ? ++this.m_numRegionActive : --this.m_numRegionActive;
    }

    public int activeRegionCount() {
        return this.m_numRegionActive;
    }

    public boolean isDirty() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            VWConfigBaseNode bNode = (VWConfigBaseNode)this.getChildAt(i);
            if (!bNode.isDirty()) continue;
            return true;
        }
        return false;
    }

    public VWConfigRegionNode findRegionNode(String routerName) {
        VWConfigRegionNode rNode = null;
        boolean bFound = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            rNode = (VWConfigRegionNode)this.getChildAt(i);
            if (VWStringUtils.compare(routerName, rNode.getRouterName()) != 0) continue;
            bFound = true;
            break;
        }
        if (bFound) {
            return rNode;
        }
        return null;
    }

    public VWConfigRegionNode findRegionNode(int regionId) {
        VWConfigRegionNode rNode = null;
        boolean bFound = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            rNode = (VWConfigRegionNode)this.getChildAt(i);
            if (rNode.getRegionID() != regionId) continue;
            bFound = true;
            break;
        }
        if (bFound) {
            return rNode;
        }
        return null;
    }

    public VWConfigRegionNode[] getRegionNodes(int opt) {
        Vector<VWConfigRegionNode> rNodeList = new Vector<VWConfigRegionNode>();
        VWConfigRegionNode rNode = null;
        boolean bFound = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            rNode = (VWConfigRegionNode)this.getChildAt(i);
            if (rNode.getSession() != null && (opt == 3 || opt == 1)) {
                rNodeList.add(rNode);
                continue;
            }
            if (opt != 3 && opt != 2) continue;
            rNodeList.add(rNode);
        }
        int sz = rNodeList.size();
        if (sz > 0) {
            Object[] rNodes = new VWConfigRegionNode[sz];
            rNodeList.copyInto(rNodes);
            return rNodes;
        }
        return null;
    }

    public VWSystemAdministration getSysAdmin() {
        return this.m_sysAdmin;
    }

    public void setSysAdmin(VWSystemAdministration sysAdmin) {
        this.m_sysAdmin = sysAdmin;
    }

    public void refresh() {
        try {
            this.refreshSessionInfo();
            VWConfigRegionNode[] activeRegions = this.getRegionNodes(1);
            if (activeRegions != null && activeRegions.length > 0) {
                for (int i = 0; i < activeRegions.length; ++i) {
                    activeRegions[i].refresh(true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void refreshSessionInfo() {
        try {
            VWConfigRegionNode rNode = null;
            VWSession vwSession = null;
            for (int i = 0; i < this.getChildCount() && (vwSession = (rNode = (VWConfigRegionNode)this.getChildAt(i)).getSession()) == null; ++i) {
            }
            if (vwSession != null) {
                this.m_sysAdmin = vwSession.fetchSystemAdministration();
                this.setSessionInfo(rNode.getSessionInfo());
            } else {
                this.m_sysAdmin = null;
                this.setSessionInfo(null);
            }
        }
        catch (VWException ex) {
            this.m_sysAdmin = null;
            this.setSessionInfo(null);
            ex.printStackTrace();
        }
    }

    public Object clone() {
        VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)super.clone();
        sNode.m_numRegionActive = this.m_numRegionActive;
        return sNode;
    }

    public IVWtoXML[] getIVWtoXMLItems() throws VWException {
        VWConfigRegionNode[] activeRegions = this.getRegionNodes(1);
        if (activeRegions != null && activeRegions.length > 0) {
            VWSystemAdministration admin;
            Vector<Object> itemsToOutput = new Vector<Object>();
            VWSession session = activeRegions[0].getSession();
            if (session != null && (admin = session.fetchSystemAdministration()) != null) {
                itemsToOutput.addElement(admin);
            }
            for (int i = 0; i < activeRegions.length; ++i) {
                if (activeRegions[i].getExportOptSelection() == 0) continue;
                itemsToOutput.addElement(activeRegions[i].getIVWtoXMLItems(false, false));
            }
            if (itemsToOutput.size() > 0) {
                Object[] apiObjects = new IVWtoXML[itemsToOutput.size()];
                itemsToOutput.copyInto(apiObjects);
                return apiObjects;
            }
        }
        return null;
    }

    public void releaseResources() {
        super.releaseResources();
        this.m_sysAdmin = null;
    }

    public void selectExportComponents() {
    }
}

